/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import javax.swing.DefaultListModel;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import net.nooj4nlp.controller.TextEncodingDialog.Text1DocumentListener;
import net.nooj4nlp.controller.TextEncodingDialog.Text2DocumentListener;
import net.nooj4nlp.controller.TextEncodingDialog.Text3DocumentListener;
import net.nooj4nlp.controller.TextEncodingDialog.Text4DocumentListener;
import net.nooj4nlp.controller.TextEncodingDialog.TextDocumentListener;
import net.nooj4nlp.engine.SystemEnvironment;
import net.nooj4nlp.gui.components.JBinaryTextField;
import net.nooj4nlp.gui.components.JDecimalTextField;
import net.nooj4nlp.gui.components.JHexdecimalTextField;

public class TextEncodingDialog
extends JInternalFrame {
    private static final long serialVersionUID = -2984243350288280598L;
    public JHexdecimalTextField fldHexadecimal;
    public JDecimalTextField fldDecimal;
    public JBinaryTextField fldBinary;
    public JTextField textField_3;
    public JTextField fldText;
    public JScrollPane scrollPane;
    public static Text1DocumentListener listener1;
    public static Text2DocumentListener listener2;
    public static Text3DocumentListener listener3;
    public static Text4DocumentListener listener4;

    public TextEncodingDialog() {
        this.setTitle("Text Encoding");
        this.setClosable(true);
        this.setIconifiable(true);
        this.getContentPane().setFont(new Font("Tahoma", 1, 18));
        this.setBounds(400, 100, 750, 400);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("insets 5", "[300!][410!]", "[100!][15!][40!][15!][50!][15!][grow][5]"));
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Base conversion & encoding:", 4, 2, null, new Color(0, 0, 0)));
        this.getContentPane().add((Component)panel, "cell 0 0, span, growx");
        panel.setLayout((LayoutManager)new MigLayout("insets 3", "[130!][85!][95!][325!][45!]", "[20!][25!][5]"));
        JLabel lblDecimalValue = new JLabel("Decimal value:");
        panel.add((Component)lblDecimalValue, "cell 0 0");
        this.fldDecimal = new JDecimalTextField();
        panel.add((Component)this.fldDecimal, "cell 1 0");
        this.fldDecimal.setColumns(10);
        JLabel lblHexadecimalValue = new JLabel("Hexadecimal value:");
        panel.add((Component)lblHexadecimalValue, "cell 0 1");
        this.fldHexadecimal = new JHexdecimalTextField();
        panel.add((Component)this.fldHexadecimal, "cell 1 1");
        this.fldHexadecimal.setColumns(10);
        JLabel lblBinaryValue = new JLabel("Binary value:");
        panel.add((Component)lblBinaryValue, "cell 2 0, gapleft 10");
        this.fldBinary = new JBinaryTextField();
        panel.add((Component)this.fldBinary, "cell 3 0, span 2, growx");
        this.fldBinary.setColumns(10);
        JLabel lblInUnicodeie = new JLabel("In Unicode (i.e. UTF32 Big Endian), this value encodes a character:");
        panel.add((Component)lblInUnicodeie, "cell 2 1, span 2, gapleft 10");
        this.textField_3 = new JTextField();
        this.textField_3.setFont(new Font("Tahoma", 1, 18));
        this.textField_3.setForeground(Color.RED);
        panel.add((Component)this.textField_3, "cell 4 1, hmin 20");
        this.textField_3.setColumns(10);
        listener1 = new Text1DocumentListener(this.fldHexadecimal, this.fldDecimal, this.fldBinary, this.textField_3);
        listener2 = new Text2DocumentListener(this.fldHexadecimal, this.fldDecimal, this.fldBinary, this.textField_3);
        listener3 = new Text3DocumentListener(this.fldHexadecimal, this.fldDecimal, this.fldBinary, this.textField_3);
        listener4 = new Text4DocumentListener(this.fldHexadecimal, this.fldDecimal, this.fldBinary, this.textField_3);
        this.fldBinary.getDocument().addDocumentListener(listener1);
        this.fldDecimal.getDocument().addDocumentListener(listener2);
        this.fldHexadecimal.getDocument().addDocumentListener(listener3);
        this.textField_3.getDocument().addDocumentListener(listener4);
        JLabel lblChooseA = new JLabel("(1) Choose a text encoding (among " + SystemEnvironment.encodings.length + "):");
        lblChooseA.setFont(new Font("Tahoma", 1, 11));
        this.getContentPane().add((Component)lblChooseA, "cell 0 1");
        DefaultListModel<String> model = new DefaultListModel<String>();
        JList listEncoding = new JList(model);
        for (int i = 0; i < SystemEnvironment.encodings.length; ++i) {
            String e = SystemEnvironment.encodings[i];
            Charset c = Charset.forName(e);
            e = e + c.aliases().toString();
            model.add(i, e);
        }
        this.scrollPane = new JScrollPane(listEncoding, 22, 32);
        this.scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        this.getContentPane().add((Component)this.scrollPane, "cell 0 2, span 1 5, grow 1");
        JLabel lblEnterA = new JLabel("(2) Enter a text:");
        lblEnterA.setFont(new Font("Tahoma", 1, 11));
        this.getContentPane().add((Component)lblEnterA, "cell 1 1");
        this.fldText = new JTextField();
        this.getContentPane().add((Component)this.fldText, "cell 1 2, grow");
        this.fldText.setColumns(10);
        JLabel lblValuedecimal = new JLabel("Value (decimal):");
        this.getContentPane().add((Component)lblValuedecimal, "cell 1 3");
        JTextArea fldValDecimal = new JTextArea();
        fldValDecimal.setBackground(new Color(227, 227, 227));
        fldValDecimal.setForeground(Color.RED);
        fldValDecimal.setBorder(new BevelBorder(1, null, null, null, null));
        fldValDecimal.setLineWrap(true);
        fldValDecimal.setWrapStyleWord(true);
        this.getContentPane().add((Component)fldValDecimal, "cell 1 4, grow");
        JLabel lblValuehexadecimal = new JLabel("Value (hexadecimal):");
        this.getContentPane().add((Component)lblValuehexadecimal, "cell 1 5");
        JTextArea fldValHexadecimal = new JTextArea();
        fldValHexadecimal.setForeground(Color.RED);
        fldValHexadecimal.setLineWrap(true);
        fldValHexadecimal.setWrapStyleWord(true);
        this.getContentPane().add((Component)fldValHexadecimal, "cell 1 6, grow");
        fldValHexadecimal.setBackground(new Color(227, 227, 227));
        fldValHexadecimal.setBorder(new BevelBorder(1, null, null, null, null));
        this.fldText.getDocument().addDocumentListener(new TextDocumentListener(listEncoding, this.fldText, fldValDecimal, fldValHexadecimal));
    }
}

